/*
	File:		RemoteAccessInterface.h

	Contains:	Interface for making remote access calls.

	Written by:	Quinn (conversion to Universal Interfaces 3.2 format)

	Copyright:	Copyright  1991-1998 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

         <1>     22/4/99    Quinn   First checked in.
*/

#ifndef __REMOTEACCESSINTERFACE__
#define __REMOTEACCESSINTERFACE__

#ifndef __TYPES__
#include <Types.h>
#endif
#ifndef __FILES__
#include <Files.h>
#endif
#ifndef __APPLETALK__
#include <AppleTalk.h>
#endif

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

/* **** These callbacks are yet to be Universal Interfaced... **** */

typedef 	pascal void (*UserStatusProcPtr)(UInt8 *, UInt8 *);
typedef 	pascal long (*PacketFilterProcPtr)(UInt8 *, UInt32, UInt32, UInt8 *, UInt32);
typedef 	pascal void (*RemmaperProcPtr)(UInt32, UInt32, UInt32, UInt8 *, UInt8 *);
typedef 	pascal void (*CallBackHookProcPtr)(UInt8 *, UInt32);
typedef 	pascal void (*CallBackCompHookProcPtr)(UInt8 *);
typedef 	pascal UInt32 (*NetValidProcPtr)(UInt8 *,AddrBlock);


#define REMOTEACCESSNAME 		"\pRemote Access"
#define REMOTEACCESSID			'strm'					// *** NOTE: "Network Extension" uses this id for its _Gestalt call

#define gestaltRemoteAccessAttr	REMOTEACCESSID
#define gestaltRemoteAccessExists	0

#define gestaltRemoteAccessCallOnly	1					/* Remote Access Client */
#define gestaltRemoteAccessMPServer	2					/* Remote Access multi-port server */
#define gestaltRemoteAccessVers2	3					/* ARA 2.0 features are available */

#define MAXSTATUSMSGSIZE		256
#define USERNAMESIZE			34
#define PASSWORDSIZE			8
#define PASSWORDBUFSIZE			PASSWORDSIZE+1

#define TIME_UNLIMITED			0xffffffff				/* indicates unlimited time allowed on connection */


#define ctlir_getConnectInfo 0x01						/* will get connect info if address is remote */
#define ctlir_disposeConnectInfo 0x02					/* will dispose info in connectInfoPtr properly */


/* control codes
*/
#define RAM_EXTENDED_CALL				23				/* make an extended call (use TRemoteAccessParamBlock)	*/

/* extended codes (must have control code set to RAM_EXTENDED_CALL)
*/
/* the first group of calls can be issued without doing a load */
#define CmdRemoteAccess_Load			1				/* loads main section of remote access */
#define CmdRemoteAccess_Unload			2				/* unloads main section */
#define CmdRemoteAccess_PassWordMunger	6				/* create a munged password */
#define CmdRemoteAccess_GetCodeHooks	7				/* get code hooks */		

/* calls that will not work until CmdRemoteAccess_Load has been done */
#define	CmdRemoteAccess_DoConnect				40				/* main thread only */
#define CmdRemoteAccess_Disconnect				42				/* disconnect */
#define CmdRemoteAccess_Status					45				/* get status information */
#define CmdRemoteAccess_IsAddressRemote			53				/* main thread only when getting/setting connect pb info */						

/* Remote Access errors */
#define ERR_BASE						-5800

#define ERR_NOTCONNECTED				(ERR_BASE-0)
#define ERR_CONNECTIONABORTED			(ERR_BASE-1)
#define ERR_ALREADYCONNECTED			(ERR_BASE-2)
#define ERR_COMMANDALREADYINPROGRESS	(ERR_BASE-3)
#define ERR_BADVERSION					(ERR_BASE-4)
#define ERR_INSHUTDOWN					(ERR_BASE-5)
#define ERR_CONNECTIONABORTING			(ERR_BASE-6)
#define ERR_ALREADYENABLED				(ERR_BASE-7)
#define ERR_ZONEBUFBADSIZE				(ERR_BASE-8)
#define ERR_CONNECTTIMEDOUT				(ERR_BASE-9)
#define ERR_CONNECTUSERTIMEDOUT			(ERR_BASE-10)
#define	ERR_BADPARAMETER				(ERR_BASE-11)
#define	ERR_NOMULTINODE					(ERR_BASE-12)
#define	ERR_ATALKNOTACTIVE				(ERR_BASE-13)
#define	ERR_NOCALLBACKSUPPORT			(ERR_BASE-14)
#define	ERR_NOTOPENEDBYTHISPB			(ERR_BASE-15)
#define ERR_NOGLOBALS					(ERR_BASE-16)
#define ERR_NOSMARTBUFFER				(ERR_BASE-17)
#define ERR_BADATALKVERS				(ERR_BASE-18)
#define ERR_VLD8_CONNECT				0
#define ERR_VLD8_CALLBACK				(ERR_BASE-19)
#define ERR_VLD8_BADVERSION				(ERR_BASE-20)
#define ERR_VLD8_BADUSER				(ERR_BASE-21)
#define ERR_VLD8_BADPASSWORD			(ERR_BASE-22)
#define ERR_VLD8_BADLINK				(ERR_BASE-23)
#define	ERR_VLD8_NOCALLBACKALLOWED		(ERR_BASE-24)
#define	ERR_VLD8_ALLCBSERVERSBUSY		(ERR_BASE-25)
#define	ERR_VLD8_GUESTNOTALLOWED		(ERR_BASE-26)
#define ERR_VLD8_SERVERISIMPOSTER		(ERR_BASE-27)
#define ERR_VLD8_LOGINNOTENABLED		(ERR_BASE-28)
#define ERR_REMOTEPORTALREADYEXISTS		(ERR_BASE-29)
#define ERR_OPENNOTALLOWED				(ERR_BASE-30)
#define ERR_NOUSERSANDGROUPS			(ERR_BASE-31)
#define ERR_PORTSHUTDOWN				(ERR_BASE-32)
#define ERR_PORTDOESNOTEXIST			(ERR_BASE-33)
#define ERR_PWNEEDEDFORENABLE			(ERR_BASE-34)
#define ERR_DAMAGED						(ERR_BASE-35)
#define ERR_NETCONFIGCHANGED			(ERR_BASE-36)
/* 2.0 and above only */
#define	ERR_NOSUPPORT_ATREMOTE			(ERR_BASE-37)
#define ERR_CONFLICTING_REQUEST			(ERR_BASE-38)
#define	ERR_VLD8_INVALIDAUTHMETHOD		(ERR_BASE-39)
#define	ERR_VLD8_CONTINUE				(ERR_BASE-40)
#define	ERR_PWCHANGECANCEL				(ERR_BASE-41)
#define ERR_VLD8_MANUALPASSWORDREQUIRED (ERR_BASE-50)

#define ERR_END							ERR_VLD8_MANUALPASSWORDREQUIRED	/* must be last error */


#define kTemplateVers			1		/* current version understood by remote access for the connect template */

/* forward defs */
typedef union TRemoteAccessParamBlock TRemoteAccessParamBlock;
typedef TRemoteAccessParamBlock *TPRemoteAccessParamBlock;


/* network transition */
struct TNetworkTransition
{
	unsigned char				*privateVars;			/* pointer used internally by Remote Access */
	NetValidProcPtr				netValidProc;			/* pointer to the network valid procedure */
	Boolean						newConnectivity;		/* set to true if new connectivity, false if loss of connectivity */
};
typedef struct TNetworkTransition TNetworkTransition;
typedef TNetworkTransition *TPNetworkTransition;


#define DControlParamHeader \
    QElem						*qLink;					/*next queue entry*/\
    short						qType;					/*queue type*/\
    short						ioTrap;					/*routine trap*/\
    Ptr							ioCmdAddr;              /*routine address*/\
    ProcPtr						ioCompletion;			/*completion routine*/\
    OSErr						ioResult;				/*result code*/\
    long						userData;				/*for use by the user */\
    short						unused;					/*unused field */\
    short						ioRefNum;				/*driver reference number*/\
    short						csCode;					/*Call command code*/

#define DExtendedParam \
	DControlParamHeader \
	Ptr							hReserved1; \
	Ptr							hReserved2; \
	Ptr							resultStrPtr; \
	Ptr							extendedType;			/* pointer to identifier string */


#define DRemoteAccessParmHeader	\
	DExtendedParam \
	short						extendedCode;			/* for use by extended call proc */\
	Ptr							portGlobalsPtr;			/* pointer to globals for this port (0=userport) */\


struct TRemoteAccessParmHeader
{
	DRemoteAccessParmHeader
};
typedef struct TRemoteAccessParmHeader TRemoteAccessParmHeader;


struct TRAConnectInfoTemplate
{
	unsigned long				version;				/* version of this format			*/
	unsigned long				ltType;					/* Link Tool type					*/
	long						addressInfoLength;		/* length of the address information */
	Ptr							addressInfoPtr;			/* pointer to connect address info */
	long						ltSpecificTemplateLength;/* length of the ltspecific information */
	Ptr							ltSpecificTemplatePtr;	/* pointer to link tool specific params */
	unsigned char				passWord[PASSWORDBUFSIZE];	/* user password					*/
	unsigned char				userName[USERNAMESIZE];	/* user name						*/
	unsigned long				connectReminderTimer;	/* value for connection	reminder in seconds	*/
	unsigned long				connectOKWaitTimer;		/* how long to wait for OK on reminder timer	*/
	Boolean						guestLogin;				/* try to log in as a guest			*/
	Boolean						passwordSaved;			/* set if password is saved			*/
	Boolean						guaranteedAccess;		/* flag to guarantee access to servers internet */

};
typedef struct TRAConnectInfoTemplate TRAConnectInfoTemplate;
typedef TRAConnectInfoTemplate *TPRAConnectInfoTemplate;


/* connect option flags
*/
#define kNSCanInteract			0x00000001				// User interaction (password prompt) is OK 
#define	kNSShowStatus			0x00000002				// show the status of the connect or disconnect call 
#define	kNSConnectDocument		0x00000004				// connect using the specified document 
#define	kNSPassWordSet			0x00000010				// use the specified password field when connecting by document 
// 2.0 and above
#define kNS2SavvyFlags			0x40000000				// Set to use the next 2 flags below for only ARA 2.0 aware applications.
#define	kNSAR2Connection		0x00000020				// connecting to a 2.0 server. 
#define	kNSNotifyWhileConnected	0x00000040				// display cute notification icon while connected.

struct TRemoteAccessConnectParam
{
	DRemoteAccessParmHeader
	TRAConnectInfoTemplate		connectInfo;			/* The connection infomation template */
	unsigned long				optionFlags;			// bit mapped connect option flags 
	FSSpec						fileInfo;				// file info for connect document 
};
typedef struct TRemoteAccessConnectParam TRemoteAccessConnectParam;


#define kNumWarnEntriesMax		5						/* number of entries in warn array */
struct TRemoteAccessDisconnectParam
{
	DRemoteAccessParmHeader
	unsigned long				disconnectin;			/* server mode: disconnect in # of seconds */
	TPRemoteAccessParamBlock	abortOnlyThisPB;		/* only abort a connection opened by this pb */
	unsigned long 				warnArr[kNumWarnEntriesMax];	/* set warn times here in seconds (zero all if no warnings) */
	unsigned long				optionFlags;			/* bit mapped connect option flags */
};
typedef struct TRemoteAccessDisconnectParam TRemoteAccessDisconnectParam;


/* bits passed back in status call */
#define CctlConnected				0x00000001		/* set when connected */
#define CctlAnswerEnable			0x00000004		/* set when we are set to answer calls */
#define CctlServerMode				0x00000008		/* set for server mode, clear for remote mode */
#define CctlConnectionAborting		0x00000010		/* connection is being torn down */
#define CctlConnectInProg			0x00000020		/* set when connection in progress or fully connected */
#define CctlDisconnectInStarted		0x00008000		/* somebody has started a disconnectIn */
#define	CctlGuestMode				0x00080000		/* set if this port is logged on with guest access */
#define ctlAR2Connection        	0x02000000		/* set when this connection is to a 2.0 server */
#define ctlNotifyWhileConnected 	0x04000000		/* set when the user wants to be reminded while connected */
#define ctlConnectedToMPS       	0x08000000		/* set when client is connected to a multi-port server */
#define CctlMultiNodeReady			0x80000000		/* shows if we currently have a multinode address */
struct TRemoteAccessStatusParam
{
	DRemoteAccessParmHeader
	unsigned long				statusBits;				/* bits for current status */
	unsigned long				timeConnected;			/* number of seconds we have been connected */
	unsigned long				timeLeft;				/* number of seconds remaining in connection (0xffffffff infinite) */
	unsigned char				*userNamePtr;			/* returns user name, expects pointer to buffer of USERNAMESIZE if non nil */
	unsigned char				*connectedToNamePtr;	/* returns name of where we connected to, expects pointer to buffer of USERNAMESIZE if non nil */
	TPRemoteAccessParamBlock	connectedByParamPtr;	/* a pointer to the parameter block "initiating" the connection if we are connected */	
	TPRemoteAccessParamBlock	statusConnectedByParamPtr;	/* a pointer to the parameter block "initiating" the connection when status was posted */
	unsigned char				*theLastStatusMsgPtr;	/* expects pointer to buffer of size MAXSTATUSMSGSIZE */
	unsigned char				*statusUserNamePtr;		/* pointer to buffer of size USERNAMESIZE */
	long						statuslttype;			/* link tool type */
	long						statusmsgOptionFlags;	/* classification of message type */
	long						statusMsgNum;			/* specific message number */
	long						statusMsgSeqNum;		/* pass in zero if always want status, otherwise use last value, if status is new, new number is returned */
	unsigned long				userSignature;			/* signature of port creator */
	unsigned long				userRefCon;				/* refcon of port creator */
};
typedef struct TRemoteAccessStatusParam TRemoteAccessStatusParam;


struct TRemoteAccessIsRemoteParms
{
	DRemoteAccessParmHeader
	long						theAddress;				/* address that is to be checked */
	unsigned long				optionFlags;			/* Set to ctlir_getConnectInfo or ctlir_disposeConnectInfo, if zero only checks address */
	Boolean						locationIsRemoteFlag;	/* returns true	if address is remote */	
	long						ConnectInfoLength;		/* length of the following data */
	TPRAConnectInfoTemplate		connectInfoPtr;			/* The connection information template pointer */
};
typedef struct TRemoteAccessIsRemoteParms TRemoteAccessIsRemoteParms;

struct TRemoteAccessPasswordMunger
{
	DRemoteAccessParmHeader
	unsigned char				*userNamePtr;			/* pointer to username string */
	unsigned char				*passWordPtr;			/* user password */	
	unsigned short				reserved;				/* must set to zero */
};
typedef struct TRemoteAccessPasswordMunger TRemoteAccessPasswordMunger;


struct TRemoteAccessGetCodeHooks
{
	DRemoteAccessParmHeader
	RemmaperProcPtr				remapperProc;			/* quick vector to remapper code */
};

typedef struct TRemoteAccessGetCodeHooks TRemoteAccessGetCodeHooks;

/* this is the union of all the different command types */
union TRemoteAccessParamBlock
{
	TRemoteAccessParmHeader		HDR;					/* header pb */
	TRemoteAccessParmHeader		LOAD;					/* load pb */
	TRemoteAccessParmHeader		UNLOAD;					/* unload pb */
	TRemoteAccessConnectParam	CONNECT;				/* connect pb */
	TRemoteAccessDisconnectParam DISCONNECT;			/* disconnect pb */
	TRemoteAccessStatusParam	STATUS;					/* get current status */
	TRemoteAccessIsRemoteParms	ISREMOTE;				/* used to check network address location */
	TRemoteAccessPasswordMunger	MUNGEPW;				/* run password through munger */
	TRemoteAccessGetCodeHooks	CODEHOOKS;				/* get internal code hooks */

	unsigned char				filler[256];			/* set the minimum size of this parameter block */
};

EXTERN_API ( OSErr ) PBRemoteAccess(TPRemoteAccessParamBlock paramBlock, Boolean async)
	TWOWORDINLINE(0x7000,0xAA5B);

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif /* __REMOTEACCESSINTERFACE__ */
